@php
    use Illuminate\Support\Carbon;
    use Illuminate\Support\Facades\Lang;

    $date = $date ?? false;

    if (!$date) {
        $dateFormat = $dateFormat ?? "%A %d %B %Y";
        $startDate = get_date_in_user_timezone($event->date);
        $endDate   = ($event->end_date !== null && $event->end_date > 0) ? get_date_in_user_timezone($event->end_date) : null;

        $date = ucwords($startDate->formatLocalized($dateFormat));
        if ($startDate !== null) {
            if ($startDate->isSameDay($endDate)) {
               $date .= Lang::get('newsletter.from_time') . $startDate->format('H:i') . Lang::get('newsletter.to_time') . $endDate->format('H:i');
            } elseif($endDate !== null) {
               $date .= ' - '  . ucwords($endDate->formatLocalized($dateFormat));
            }
        }
    }

    $lineColor = $lineColor ?? '#A0B9EF';
    if($event->eventsCategories->isNotEmpty()) {
        $lineColor = $event->eventsCategories->first()->color ?? $lineColor;
    }

    if (!isset($margin)) {
       $margin = 77;
    }

@endphp
<!-- BEGIN EVENT LINE //-->
<table cellpadding="0" cellspacing="0" width="100%"
       style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;"
       role="presentation">
    <tr>
        @if($margin > 0)
        <td style="width:{{ $margin + 10 }}px" valign="top">
        @endif
        <td style="width: 3px; background-color: {{ $lineColor }};" bgcolor="{{ $lineColor }}"></td>
        <td>
            <table>
                <tr style="border-collapse:collapse">
                    <td style="width:20px;"></td>
                    <td align="left" style="padding:0;Margin:0;padding-top:10px;"><p
                            style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-size:14px;font-family:arial, 'helvetica neue', helvetica, sans-serif;line-height:21px;color:#727272">
                            {{$date}}</p></td>
                </tr>
                <tr style="border-collapse:collapse">
                    <td style="width:20px;"></td>
                    <td align="left" style="padding:0;Margin:0;padding-bottom:10px;"><p
                            style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-size:16px;font-family:arial, 'helvetica neue', helvetica, sans-serif;line-height:24px;color:#181744">
                            <strong><a href="{{ url(\Illuminate\Support\Arr::first($event->slug)) }}" target="_blank" style="box-sizing: border-box; -webkit-text-size-adjust: none;-ms-text-size-adjust: none; mso-line-height-rule: exactly; font-family:arial, 'helvetica neue', helvetica, sans-serif; font-size: 17px;text-decoration: none; color: {{ $titleColor ?? '#2C3E50' }};">{{ $event->title }}</a></strong>
                        </p></td>
                </tr>
            </table>
        </td>
        <td style="width:{{ $margin }}px" valign="top">
    </tr>
    <tr>
        <td height="15px" style="height:15px;"></td>
    </tr>
</table>
<!-- END EVENT LINE //-->
