@php
use Inside\Support\Str;
$fullname = trim(($user->title ?? '') . Str::ucfirst(Str::lower($user->firstname)) . ' ' . Str::upper($user->lastname));
@endphp
<!-- BEGIN DESCRIPTION //-->
<table cellpadding="0" cellspacing="0" width="100%" role="presentation"
       style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;">
    @if(isset($title) && !empty($title))
    <tr style="border-collapse:collapse">
        <td align="center" style="padding:0;Margin:0;padding-bottom:25px"><span
                style="color:{{ $titleColor ?? 'black' }};font-family:arial, 'helvetica neue', helvetica, sans-serif;font-size:14px"><strong>{{ $title}}</strong></span>
        </td>
    </tr>
    @endif
    @if(isset($welcome) && !empty($welcome))
        <tr style="border-collapse:collapse">
            <td align="left" style="padding:0;Margin:0"><span
                    style="font-family:arial, 'helvetica neue', helvetica, sans-serif;font-size:17px;color:#2C3E50"><strong>{{ $welcome }}</strong></span>
            </td>
        </tr>
    @else
        <tr style="border-collapse:collapse">
            <td align="left" style="padding:0;Margin:0"><span
                    style="font-family:arial, 'helvetica neue', helvetica, sans-serif;font-size:17px;color:#2C3E50"><strong>@lang('newsletter.welcome', ['fullname' => $fullname, 'firstname' => $user->firstname, 'lastname' => $user->lastname, 'title' => $user->title ?? ''])</strong></span>
            </td>
        </tr>
    @endif
    <tr style="border-collapse:collapse">
        <td align="left" style="padding-left:0;padding-right:0;padding-top:0;padding-bottom:{{ $paddingBottom ?? 0 }}px;Margin:0;"><p
                style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-size:14px;font-family:arial, 'helvetica neue', helvetica, sans-serif;line-height:21px;color:{{ $color }}">{!!  $slot  !!}</p></td>
    </tr>
</table>
<!-- END DESCRIPTION //-->
