<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Bridge\BridgeContent;
use Illuminate\Support\Facades\Artisan;

class AddFieldsSentAtToNewsletters extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();
        $bridgeContent = new BridgeContent();

        collect(data_get(config('newsletters'), 'types'))
            ->keys()
            ->filter(fn (string $type) => Schema::hasContentType($type))
            ->each(function ($type) use ($bridge, $bridgeContent) {
                $bridge->contentTypeCreateOrUpdateField($type, 'sent_at', [
                    'name' => 'sent_at',
                    'searchable' => false,
                    'translatable' => false,
                    'search_result_field' => false,
                    'required' => false,
                    'weight' => 0,
                    'title' => [
                        'fr' => 'Envoyé le',
                        'en' => 'Sent at',
                        'es' => 'Enviado el',
                        'de' => 'Gesendet am',
                        'pt' => 'Enviado em',
                        'nl' => 'Verzonden op',
                    ],
                    'description' => [],
                    'widget' => [
                        'hidden' => true,
                    ],
                    'type' => BridgeContentType::TIMESTAMP_FIELD,
                    'settings' => [
                        'cardinality' => 1,
                    ],
                ]);

                Artisan::call('models:rebuild');
                Artisan::call('inside:newsletter:setup:settings');

                $newsletters = type_to_class($type)::all();
                $newsletters->pluck('uuid')->each(function ($uuid) use ($type, $bridgeContent) {
                    $sentAt = \Inside\Newsletters\Models\NewslettersSent::query()->where('uuid', $uuid)->max('date_sent');
                    if ($sentAt) {
                        $bridgeContent->contentUpdate($type, [
                            'uuid' => $uuid,
                            'sent_at' => $sentAt
                        ]);
                    }
                });
            });
    }
}
