<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Content\Facades\Schema;

class AddDescriptionForLogoBannerInNewsletter extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $fields = [
            'nl_banner' => [
                'title' => [
                    'fr' => 'Bannière',
                    'en' => 'Banner',
                    'de' => 'Banner',
                    'es' => 'Pancarta',
                    'pt' => 'Banner',
                    'nl' => 'Banner',
                ],
                'description' => [
                    'fr' => 'L\'image par défaut correspond à celle définie dans les paramètres avancés de l\'intranet. Si vous ajoutez une nouvelle image ici, celle-ci remplacera l\'image des paramètres avancés pour cette newsletter',
                    'en' => 'The default image corresponds to the one defined in the intranet\'s advanced settings. If you add a new image here, it will replace the image from the advanced settings for this newsletter.',
                    'de' => 'Das Standardbild entspricht dem in den erweiterten Einstellungen des Intranets definierten Bild. Wenn Sie hier ein neues Bild hinzufügen, wird es das Bild aus den erweiterten Einstellungen für diesen Newsletter ersetzen.',
                    'es' => 'La imagen predeterminada corresponde a la definida en la configuración avanzada del intranet. Si agrega una nueva imagen aquí, reemplazará la imagen de la configuración avanzada para este boletín.',
                    'pt' => 'A imagem padrão corresponde àquela definida nas configurações avançadas do intranet. Se você adicionar uma nova imagem aqui, ela substituirá a imagem das configurações avançadas para este boletim.',
                    'nl' => 'Het standaardbeeld komt overeen met het beeld dat is gedefinieerd in de geavanceerde instellingen van het intranet. Als u hier een nieuw beeld toevoegt, vervangt dit het beeld uit de geavanceerde instellingen voor deze nieuwsbrief.',
                ],
                'settings' => [
                    'min_resolution' => '690x130',
                    'max_resolution' => '690x130',
                    'uri_scheme' => 'public',
                    'default_image' => [
                        'uuid' => '',
                        'alt' => '',
                        'title' => '',
                        'width' => null,
                        'height' => null,
                    ],
                    'target_type' => 'file',
                    'display_field' => false,
                    'display_default' => false,
                    'cardinality' => 1,
                ],
                'weight' => 1,
            ],
            'nl_logo' => [
                'title' => [
                    'fr' => 'Logo',
                    'en' => 'Logo',
                    'de' => 'Logo',
                    'es' => 'Logotipo',
                    'pt' => 'Logotipo',
                    'nl' => 'Logo',
                ],
                'description' => [
                    'fr' => 'L\'image par défaut correspond à celle définie dans les paramètres avancés de l\'intranet. Si vous ajoutez une nouvelle image ici, celle-ci remplacera l\'image des paramètres avancés pour cette newsletter',
                    'en' => 'The default image corresponds to the one defined in the intranet\'s advanced settings. If you add a new image here, it will replace the image from the advanced settings for this newsletter.',
                    'de' => 'Das Standardbild entspricht dem in den erweiterten Einstellungen des Intranets definierten Bild. Wenn Sie hier ein neues Bild hinzufügen, wird es das Bild aus den erweiterten Einstellungen für diesen Newsletter ersetzen.',
                    'es' => 'La imagen predeterminada corresponde a la definida en la configuración avanzada del intranet. Si agrega una nueva imagen ici, remplacera la imagen de la configuración avanzada para este boletín.',
                    'pt' => 'A imagem padrão corresponde àquela definida nas configurações avançadas do intranet. Se você adicionar uma nova imagem aqui, ela substituirá a imagem das configurações avançadas para este boletim.',
                    'nl' => 'Het standaardbeeld komt overeen met het beeld dat is gedefinieerd in de geavanceerde instellingen van het intranet. Als u hier een nieuw beeld toevoegt, vervangt dit het beeld uit de geavanceerde instellingen voor deze nieuwsbrief.',
                ],
                'settings' => [
                    'min_resolution' => '233x40',
                    'max_resolution' => '233x40',
                    'uri_scheme' => 'public',
                    'default_image' => [
                        'uuid' => '',
                        'alt' => '',
                        'title' => '',
                        'width' => null,
                        'height' => null,
                    ],
                    'target_type' => 'file',
                    'display_field' => false,
                    'display_default' => false,
                    'cardinality' => 1,
                ],
                'weight' => 2,
            ],
        ];

        collect(data_get(config('newsletters'), 'types'))
            ->keys()
            ->filter(fn (string $type) => Schema::hasContentType($type))
            ->each(fn (string $type) => collect($fields)->each(
                fn ($field, $fieldName) => $bridge->contentTypeUpdateField(
                    type: $type,
                    fieldName: $fieldName,
                    options: [
                        'name' => $fieldName,
                        'required' => false,
                        'translatable' => true,
                        'title' => $field['title'],
                        'description' => $field['description'],
                        'widget' => [
                            'type' => BridgeContentType::IMAGE_WIDGET,
                            'settings' => [
                                'progress_indicator' => 'throbber',
                                'preview_image_style' => 'thumbnail',
                            ],
                            'hidden' => false,
                            'weight' => 1,
                        ],
                        'type' => BridgeContentType::IMAGE_FIELD,
                        'settings' => $field['settings'],
                    ],
                    weight: $field['weight']
                )
            ));
    }
}
