<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Newsletters\Jobs\RunNewsletterStatsCommand;

class MigrateNewslettersStatistics extends Migration
{
    public function up(): void
    {
        $runAt = now()->setTime(18, 0);
        if (now()->lessThan($runAt)) {
            RunNewsletterStatsCommand::dispatch()->delay($runAt);
        } else {
            RunNewsletterStatsCommand::dispatch()->delay($runAt->addDay());
        }
    }
}
