<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Arr;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Settings\Models\Setting;

class CleanLangNewslettersSettings extends Migration
{
    private const GROUP = 'newsletter';

    public function up(): void
    {
        $newsletters = collect(config('newsletters.types'))->pluck('notification.view');
        if ($newsletters->count() !== 1) {
            return;
        }

        $newsletter = config('app.code');
        $configPath = back_path("resources/newsletters/".$newsletter.".php");
        if (!file_exists($configPath)) {
            return;
        }

        $config = include $configPath;

        collect([
            'newsletters_display_hello',
            'show_newsletter_button'
        ])->each(
            fn ($fieldToCreate) => $this->addMissingSettings($fieldToCreate)
        );


        $this->removeUselessSettings($config);
    }

    private function removeUselessSettings(array $config): void
    {
        $newsletterType = Arr::get($config, '_meta.type');
        collect(['say_greeting','title', 'introduction','content', 'image'])
            ->each(function ($key) use ($newsletterType) {
                foreach (list_languages() as $language) {
                    $completeKey = sprintf('%s_%s_%s', $newsletterType, $key, $language);
                    if (Setting::firstWhere(['key' => $completeKey, 'group' => self::GROUP]) !== null) {
                        Setting::where(['key' => $completeKey, 'group' => self::GROUP])->delete();
                    }
                }
            });
    }

    private function addMissingSettings(string $key): void
    {
        Setting::firstOrCreate(['group' => self::GROUP, 'key' => $key], ['value' => true]);
    }
}
