<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema;
use Inside\Host\Bridge\BridgeContentType;

class AddFieldsScheduledAtToNewsletters extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        collect(data_get(config('newsletters'), 'types'))
            ->keys()
            ->filter(fn (string $type) => Schema::hasContentType($type))
            ->each(fn (string $type) => $bridge->contentTypeCreateOrUpdateField($type, 'scheduled_at', [
                'name' => 'scheduled_at',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'required' => false,
                'weight' => 0,
                'title' => [
                    'fr' => 'Programmé à',
                    'en' => 'Scheduled at',
                    'es' => 'Programado en',
                    'de' => 'Geplant am',
                    'pt' => 'Programado em',
                    'nl' => 'Gepland op',
                ],
                'description' => [],
                'widget' => [
                    'hidden' => true,
                ],
                'type' => BridgeContentType::TIMESTAMP_FIELD,
                'settings' => [
                    'cardinality' => 1,
                ],
            ]));
    }
}
