<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Inside\Notify\Models\NotificationType;

class AddedSentDateToNewslettersSentTable extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasTable('inside_newsletters_sent')) {
            return;
        }

        Schema::table('inside_newsletters_sent', function (Blueprint $table) {
            $table->string('langcode')->nullable();
            $table->date('date_sent')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('inside_newsletters_sent', function (Blueprint $table) {
            $table->dropColumn('langcode');
            $table->dropColumn('date_sent');
        });
    }
}
