<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Inside\Notify\Models\NotificationType;

class InstallNewsletters extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasTable('inside_newsletters_sent')) {
            Schema::create('inside_newsletters_sent', function (Blueprint $table) {
                $table->uuid('uuid');
                $table->string('type');
                $table->uuid('user_uuid');
                $table->foreign('user_uuid')
                  ->references('uuid')
                  ->on('inside_users')
                  ->onDelete('cascade');
            });

            Schema::table(
                'inside_newsletters_sent',
                function (Blueprint $table) {
                    $table->index(['uuid', 'type']);
                    $table->index(['uuid', 'type', 'user_uuid']);
                }
            );
        }

        NotificationType::firstOrCreate([
            'via' => 'email',
            'default' => true,
            'event' => 'Inside\Newsletters\Events\NewsletterTriggeredEvent',
            'model' => false,
            'action' => 'newsletter',
            'condition' => false,
            'multiple' => false,
            'language' => false,
            'profile' => false
        ]);

        NotificationType::firstOrCreate([
            'via' => 'email',
            'default' => true,
            'event' => 'Inside\Newsletters\Events\NewsletterTestTriggeredEvent',
            'model' => false,
            'action' => 'newsletter',
            'condition' => false,
            'multiple' => false,
            'language' => false,
            'profile' => false
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('inside_newsletters_sent');
    }
}
