<?php

use Illuminate\Support\Facades\Route;

Route::group([
    'namespace' => 'Inside\Newsletters\Http\Controllers',
    'prefix' => 'api/v1',
    'middleware' => ['auth.backoffice.access:newsletter'],
], function ($router) {
    $router->get('newsletters', ['uses' => 'NewslettersController@list']);
    $router->get('newsletters/view/{type}/{uuid}', ['uses' => 'NewslettersController@view']);
    $router->post('newsletters/send/{type}/{uuid}', ['uses' => 'NewslettersController@send']);
    $router->post('newsletters/{type}/{uuid}/schedule', ['uses' => 'NewslettersController@scheduleDelivery', 'as' => 'newsletters.schedule']);
    $router->post('newsletters/{type}/{uuid}/cancel', ['uses' => 'NewslettersController@cancelScheduledDelivery', 'as' => 'newsletters.cancel']);

    $router->get('newsletters/test-emails', ['uses' => 'TestEmailsController@list']);
    $router->post('newsletters/test-emails', ['uses' => 'TestEmailsController@store']);
    $router->delete('newsletters/test-emails/{email}', ['uses' => 'TestEmailsController@delete']);
});

Route::group([
    'namespace' => 'Inside\Newsletters\Http\Controllers',
    'prefix' => '',
], function ($router) {
    $router->get('newsletters/{type}/{newsletterUuid}/{userUuid}/viewed.png', ['uses' => 'NewslettersStatsController@viewed', 'as' => 'newsletters.viewed']);
    $router->get('newsletters/{type}/{newsletterUuid}/{userUuid}/clicked', ['uses' => 'NewslettersStatsController@clicked', 'as' => 'newsletters.clicked']);
    $router->get('newsletter_files/{token}/{params}', ['uses' => 'NewslettersSignedUrlController@serve']);
    $router->get('newsletter_content_files/{contentType}/{contentUuid}', ['uses' => 'NewslettersContentUrlController@serve']);
    $router->get('newsletter_assets/{newsletterUuid}/{fieldName}', ['uses' => 'NewslettersAssetUrlController@serve']);
});


Route::group([
    'namespace' => 'Inside\Newsletters\Http\Controllers',
    'prefix' => 'api/v1',
    'middleware' => ['auth.backoffice.access:newsletter'],
], function ($router) {
    $router->get('newsletters/types', ['uses' => 'NewslettersStatsController@types']);
    $router->get('newsletters/stats', ['uses' => 'NewslettersStatsController@list']);
    $router->get('newsletters/stats/export', ['uses' => 'NewslettersStatsController@export']);
    $router->get('newsletters/stats/{newsletterUuid}/views', ['uses' => 'NewslettersStatsController@views']);
    $router->get('newsletters/stats/{newsletterUuid}/views/export', ['uses' => 'NewslettersStatsController@viewsExport']);
});


Route::group([
    'namespace' => 'Inside\Newsletters\Http\Controllers',
    'prefix' => 'api/v1',
    'middleware' => ['auth.api'],
], function ($router) {
    // subscriptions
    $router->get('newsletters/subscriptions', ['uses' => 'NewslettersController@getSubscriptions']);
    $router->post('newsletters/subscribe/{type}', ['uses' => 'NewslettersController@subscribe']);
    $router->delete('newsletters/unsubscribe/{type}', ['uses' => 'NewslettersController@unsubscribe']);
});
