<?php

namespace Inside\Newsletters\Views\Components;

use Illuminate\Support\Facades\View;
use Inside\Content\Facades\Schema as InsideSchema;
use Inside\Content\Models\Content;
use Inside\Content\Models\Contents\Users;
use Inside\Support\Str;
use Inside\Support\View\Component;

class Introduction extends Component
{
    /** @var array */
    public $options;

    /** @var \Illuminate\Support\Collection */
    public $items;

    /** @var Content */
    public $newsletter;

    /** @var string */
    public $locale;

    /** @var Users */
    public $user;

    public function __construct(array $options = [])
    {
        $this->options    = $options;
        $this->newsletter = View::shared('newsletter');
        $this->locale     = View::shared('locale');
        $this->items      = collect($this->options['items'] ?? []);
        $this->user       = View::shared('user');
    }

    public function render()
    {
        $locale = $this->locale;


        $introductionFieldName = $this->options['introductionFieldName'] ??
            'newsletter_introduction';
        $textColor             = $this->options['textColor'] ?? '#2C3E50';
        $showGreetings         = $this->options['showGreetings'] ?? false;
        $greetingsStrKey       = $this->options['greetingsStrKey'] ??
            'newsletter.welcome';
        $greetingsTextColor    = $this->options['greetingsTextColor'] ??
            '#2C3E50';

        $languages = list_languages();
        $fullname  = trim(($this->user->title ?? '')
            .Str::ucfirst(Str::lower($this->user->firstname)).' '
            .Str::upper($this->user->lastname));

        $introduction = '';
        if (!InsideSchema::hasField(
            class_to_type($this->newsletter),
            $introductionFieldName.'_'.$locale
        )
        ) {
            $introduction = $this->newsletter->{$introductionFieldName};
        } else {
            $introduction = $this->newsletter->{$introductionFieldName.'_'
            .$locale};
        }
        $introduction = str_replace(
            '<p>',
            '<p style="font-family: Arial; font-size: 14px; color: '.$textColor
            .'; margin: 0;">',
            $introduction
        );

        $greetings = __('newsletter.welcome', [
            'fullname'  => $fullname,
            'firstname' => $this->user->firstname,
            'lastname'  => $this->user->lastname,
            'title'     => $this->user->title ?? '',
        ]);

        return view(
            'iln::components.introduction',
            compact(
                'introduction',
                'textColor',
                'showGreetings',
                'greetings',
                'greetingsTextColor'
            )
        );
    }
}
