<?php

namespace Inside\Newsletters\Services;

use Illuminate\Support\Arr;
use Inside\Content\Facades\Schema as InsideSchema;
use Inside\Content\Models\Content;
use Inside\User\Models\User;
use Inside\Authentication\Models\User as AuthUser;
use Inside\Permission\Facades\Permission;

/**
 * @TODO: Pierre, remove this during permission refactoring
 * Check every method that uses this service and replace it with the new permission service
 */
class PermissionService
{
    public function hasAccess(Content $content, User|AuthUser $user): bool
    {
        if ($user->permission->hasRole('super_administrator')) {
            return true;
        }

        if ($this->hasReadPermission($content, $user)) {
            $custom = config('permission.custom_access_restriction.' . $content->contentType, false);

            return is_callable($custom) ? $custom($user, $content) : true;
        }

        return false;
    }

    private function hasReadPermission(Content $content, User|AuthUser $user): bool
    {
        return Permission::allowed('read', $content->contentType, $content->uuid, $user);
    }
}
