<?php

namespace Inside\Newsletters\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

/**
 * @method static Builder where($column, $operator = null, $value = null, $boolean = 'and')
 * @method static \Illuminate\Support\Collection pluck(string $column, string|null $key = null)
 * @method static static create(array $attributes = [])
 * @method static bool insert(array $values)
 * @method static bool delete()
 */
class TestEmail extends Model
{
    protected $table = 'test_emails';

    protected $primaryKey = 'uuid';

    protected $keyType = 'string';

    public $incrementing  = false;

    protected $fillable = ['email'];

    protected static function boot(): void
    {
        parent::boot();

        static::creating(function ($model) {
            $model->uuid = (string) Str::uuid();
        });
    }
}
