<?php

namespace Inside\Newsletters\Models;

use Illuminate\Database\Eloquent\Model;
use Inside\Database\Eloquent\Builder;
use Inside\Database\Eloquent\WithEnhancedBuilder;

/**
 * @property int $id
 * @property string $newsletters_uuid
 * @property string $user_uuid
 * @property string $statistic_type
 * @property int $created_at
 *
 * @method static static create(array $attributes = [])
 * @method static static firstOrCreate($data)
 * @method static static firstOrFail(array $attributes = [])
 * @method static static updateOrCreate(array $attributes, array $values = [])
 * @method static static|null firstWhere($column, $operator = null, $value = null, $boolean = 'and')
 * @method static Builder query()
 * @method static Builder where($column, $operator = null, $value = null, $boolean = 'and')
 *
 * @mixin Collection
 */
class NewslettersStatistics extends Model
{
    use WithEnhancedBuilder;

    public const TYPE_SENT = 'sent';
    public const TYPE_CLICKED = 'clicked';
    public const TYPE_VIEWED = 'viewed';

    public const TYPES = [
        self::TYPE_SENT,
        self::TYPE_CLICKED,
        self::TYPE_VIEWED,
    ];

    protected $table = 'inside_newsletters_statistics';

    protected $primaryKey = 'id';

    public $timestamps = false;

    protected $fillable = [
        'newsletters_uuid',
        'user_uuid',
        'statistic_type',
        'created_at',
    ];

    protected $casts = [
        'created_at' => 'timestamp',
    ];
}
