<?php

namespace Inside\Newsletters\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Inside\Database\Eloquent\Builder;
use Inside\Database\Eloquent\WithEnhancedBuilder;

/**
 * @property string $uuid
 * @property string $user_uuid
 * @property string $type
 * @property string $langcode
 * @property int $date_sent
 *
 * @method static static create(array $attributes = [])
 * @method static static firstOrCreate($data)
 * @method static static firstOrFail(array $attributes = [])
 * @method static static updateOrCreate(array $attributes, array $values = [])
 * @method static static|null firstWhere($column, $operator = null, $value = null, $boolean = 'and')
 * @method static Builder query()
 * @method static Builder where($column, $operator = null, $value = null, $boolean = 'and')
 *
 * @mixin Collection
 */
class NewslettersSent extends Model
{
    use WithEnhancedBuilder;

    protected $table = 'inside_newsletters_sent';

    protected $casts = [
        'date_sent' => 'date',
    ];

    public function getDateSentAttribute(string $value): string
    {
        return Carbon::parse($value)->toDateString();
    }
}
