<?php

declare(strict_types=1);

namespace Inside\Newsletters\Http\Controllers;

use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Encryption\Encrypter;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;
use Inside\Kernel\Exception\FileNotFoundException;
use Inside\Kernel\Filesystem\Facades\FileStreamer;
use Symfony\Component\HttpFoundation\StreamedResponse;

/**
 * @class NewslettersSignedUrlController
 * @deprecated
 *
 * Allow streaming newsletter files.
 * should be used only to keep backward compatibility for newsletters sent in the past
 *
 */
final class NewslettersSignedUrlController
{
    /**
     * @param string $token
     * @param string $params
     * @return StreamedResponse
     */
    public function serve(string $token, string $params): StreamedResponse
    {
        $encrypted = $params;
        $key = config('app.newsletter_key');

        if (Str::startsWith($key, 'base64:')) {
            $key = base64_decode(substr($key, 7));
        }

        $encrypter = new Encrypter($key, 'AES-256-CBC');
        $params = json_decode($encrypter->decrypt($params), true);

        if (!$params) {
            throw new ModelNotFoundException("Can not load params for newsletter");
        }

        $path = $params['path'];

        if (empty($path) && !empty($params['content_type']) && !empty($params['content_uuid'])) {
            $model = type_to_class($params['content_type'])::withoutGlobalScopes()->findOrFail($params['content_uuid']);
            $fieldName = empty($model->image) ? 'file' : 'image';
            $path = (string)get_stylized_image_url($model, $fieldName, 'thumbnail', true);
        }

        return FileStreamer::streamFile($path);
    }
}
