<?php

namespace Inside\Newsletters\Exports;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Str;
use PhpOffice\PhpSpreadsheet\Shared\Date;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;

class NewslettersStatisticsExport extends AbstractStatisticsExport
{
    private array $filters;
    private string $langcode;

    public function __construct(string $langcode, array $filters = [])
    {
        parent::__construct();
        $this->filters = $filters;
        $this->langcode = $langcode;
    }

    public function query(): Builder
    {
        return $this->statisticsService->getNewslettersStatisticsQuery($this->filters);
    }

    public function headings(): array
    {
        Lang::setLocale($this->langcode);

        return [
            Lang::get("statistics.newsletters.cols.title"),
            Lang::get("statistics.newsletters.cols.sentDate"),
            Lang::get("statistics.newsletters.cols.sent"),
            Lang::get("statistics.newsletters.cols.views"),
            Lang::get("statistics.newsletters.cols.clicks"),
            Lang::get("statistics.newsletters.cols.uniqueClicks"),
            Lang::get("statistics.newsletters.cols.langcode"),
        ];
    }

    public function map($row): array
    {
        return [
            $row->title,
            $row->sent_at,
            $row->total_sent,
            $row->total_views,
            $row->clicks,
            $row->unique_clicks,
            $row->langcode ? Str::upper($row->langcode) : '-',
        ];
    }
}
