<?php

namespace Inside\Newsletters\Exports;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Support\Facades\Lang;

class NewslettersEventsExport extends AbstractStatisticsExport
{
    private array $filters;
    private string $langcode;
    private string $newsletterUuid;
    private ?string $query;

    public function __construct(string $newsletterUuid, string $langcode, array $filters = [], ?string $query = null)
    {
        parent::__construct();
        $this->filters = $filters;
        $this->langcode = $langcode;
        $this->newsletterUuid = $newsletterUuid;
        $this->query = $query;
    }

    public function query(): Builder
    {
        return $this->statisticsService->getNewsletterViewsQuery($this->newsletterUuid, $this->query, $this->filters);
    }

    public function headings(): array
    {
        Lang::setLocale($this->langcode);

        return [
            Lang::get("statistics.views.cols.email"),
            Lang::get("statistics.views.cols.full_name"),
        ];
    }

    public function map($row): array
    {
        return [
            $row->email,
            $row->full_name
        ];
    }
}
