@if($items->isNotEmpty())
    <table cellpadding="0" cellspacing="0" border="0" style="width: 100%; margin-bottom: {{$sectionMarginBottom}}px">
        <tr>
            <td>
                <x-iln::partials.section-title :title="__($sectionTitleStrKey)" />
            </td>
        </tr>
        @if($orientation == 'vertical')
        @foreach($items as $item)
            <x-dynamic-component :component="$sectionComponentName" :item="$item" :itemOptions="$options" :last="$loop->last" />
        @endforeach
        @else
            <table cellpadding="0" cellspacing="0" border="0" style="width: 100%;">
                <tr class="flex-mobile">
                    @foreach($items as $item)
                    <td style="width={{ $columnWidthPercent }}%">
                        <x-dynamic-component :component="$sectionComponentName" :item="$item" :itemOptions="$options" :last="$loop->last" />
                    </td>
                    @endforeach
                </tr>
            </table>
        @endif
        @if(isset($options['link']))
        <tr>
            <td>
                <x-iln::partials.section-link :sectionLinkOptions="$options['link'] ?? []" :section-name="$name" />
            </td>
        </tr>
        @endif
    </table>
@endif
