@props(['options' => [], 'name' => 'social'])
@php
    use Illuminate\Support\Carbon;
    use Inside\Support\Str;
    use Illuminate\Support\Arr;
    use Illuminate\Support\Facades\File;
    use Inside\Content\Facades\Schema as InsideSchema;

    $url = $options['url'] ?? url('/');

    $defaultTextColor = $options['defaultTextColor'] ?? '#fff';
    $textColor = $options['textColor'] ?? $defaultTextColor;

    $image = $options['image'] ?? null;
    $imageUrl = $options['imageUrl'] ?? null;

    // imageUrl always overrite image config
    if ($imageUrl === null) {
        if ($image === null) {
            $image = $name;
        }
        if (strpos($image, 'vendor/') === 0) {
            $path = $image;
        } else {
            $path = 'vendor/maecia/inside-newsletters/resources/images/iln/socials/' . $image . '.png';
        }
        if (File::exists(cms_base_path($path))) {
            $imageUrl = url($path);
        }
    }
    if ($imageUrl === null) {
        $imageUrl = url('vendor/maecia/inside-newsletters/resources/images/facebook.png'); // default to facebook picto
    }

    $titleStrKey = $options['titleStrKey'] ?? 'newsletter.socials.'.$name.'_title';

@endphp
<td>
    <table cellpadding="0" cellspacing="0" border="0" style="margin: auto;">
        <tr>
            @if ($imageUrl)
            <td>
                <a href="{{ $url }}" class="social-container" target="_blank" style="text-decoration: none;"><img
                        src="{{ $imageUrl }}" role="presentation" /></a>
            </td>
            <td style="width: 8px;">
                <span></span>
            </td>
            @endif
            <td>
                <a href="{{ $url }}" class="social-container" target="_blank" style="text-decoration: none;"><span
                        style="color: {{ $textColor }}; font-family: Arial; font-size: 14px; letter-spacing: 0; line-height: 16px;">{{ __($titleStrKey) }}</span></a>
            </td>
        </tr>
    </table>
</td>
