@props(['itemOptions' => [], 'item' =>null, 'last' => false])
@php
    use Illuminate\Support\Carbon;
    use Inside\Support\Str;
    use Illuminate\Support\Arr;
    use Inside\Newsletters\Facades\UrlSigner;

    // Prepare options
    $imageStyle = $itemOptions['imageStyle'] ?? 'avatar';
    $defaultImageUrl = $itemOptions['defaultImageUrl'] ?? (config('app.url') . '/vendor/maecia/inside-newsletters/resources/images/iln/default_avatar.png');
    $titleColor = $itemOptions['titleColor'] ??'#2C3E50';
    $showIntroduction = $itemOptions['showIntroduction'] ?? true;
    $introductionColor = $itemOptions['introductionColor'] ?? '#4D4D4D';
    $introductionLength = $itemOptions['introductionLength'] ?? 100;
    $introductionFieldName = $itemOptions['introductionFieldName'] ?? 'chapo';
    if ($item->contentType === "movements") {
        $movementUser = $item->movementsUsers[0];
        $thumbnailUrl = newsletter_signed_url($user, $newsletter, $movementUser, get_stylized_image_url($movementUser, 'image', $imageStyle ?? 'avatar', true), $defaultImageUrl . '?'.time());
    } else {
        $thumbnailUrl = newsletter_signed_url($user, $newsletter, $item, get_stylized_image_url($item, 'image', $imageStyle ?? 'avatar', true), $defaultImageUrl . '?'.time());
    }

    $introductionCallback = $itemOptions['introductionCallback'] ?? null;

    $introduction = $item->{$introductionFieldName};

    if (is_callable($introductionCallback)) {
        $introduction = $introductionCallback($item);
    }

    if (!isset($options['preview'])) {
        $url = UrlSigner::signedRoute('newsletters.clicked', ['type' => $newsletter->content_type, 'newsletterUuid' => $newsletter->uuid, 'userUuid' => $user->uuid, 'redirect' => Arr::first($item->slug)]);
    } else {
        $url = url(Arr::first($item->slug));
    }
@endphp
<tr>
    <td>
        <table cellpadding="0" class="news-container" cellspacing="0" border="0" style="width: 100%;">
            <tr>
                <td>
                    <table cellpadding="0" cellspacing="0" border="0" style="width: 100%;">
                        <tr class="mobile-show" style="display:none;">
                            <td class="mobile-show" style="width: 100%;">
                                <a href="{{ $url }}" target="_blank"
                                   style="text-decoration: none;">
                                    <img src="{{ url($thumbnailUrl) }}" alt="{{ $item->title }}"
                                         style="display: block; height: auto; width: 100%;" width="100%" />
                                </a>
                            </td>
                        </tr>
                        <tr class="mobile-show" style="height: 8px; display: none;" height="8">
                            <span></span>
                        </tr>
                        <tr>
                            <td class="no-mobile" style="width: 55px;">
                                <a href="{{ $url }}" target="_blank"
                                   style="text-decoration: none;">
                                    <img src="{{ url($thumbnailUrl) }}" alt="{{ $item->title }}"
                                         style="display: block;height: auto;" width="50" />
                                </a>
                            </td>
                            <td class="no-mobile" style="width: 16px;" width="16">
                                <span></span>
                            </td>
                            <td>
                                <table cellpadding="0" cellspacing="0" border="0" style="width: 100%;">
                                    <tr>
                                        <td style="height: 8px;">
                                            <span></span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <a href="{{ $url }}"
                                               target="_blank" style="text-decoration: none;">
                                                <h2 style="color: {{ $titleColor }}; font-family: Arial; font-size: 17px; font-weight: bold; letter-spacing: 0; line-height: 21px; margin: 0;">
                                                    {{ $item->title }}</h2></a>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="height: 8px;">
                                            <span></span>
                                        </td>
                                    </tr>
                                    @if($showIntroduction && !is_null($introduction))
                                        <tr>
                                            <td>
                                                <p style="color: {{ $introductionColor }}; font-family: Arial; font-size: 14px; letter-spacing: 0; line-height: 20px; margin: 0;">
                                                    {{ htmlTruncate($introduction, $introductionLength) }}</p>
                                            </td>
                                        </tr>
                                    @endif
                                </table>
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
            @if(!$last)
                <tr>
                    <td style="height: 32px;">
                        <span></span>
                    </td>
                </tr>
            @endif
        </table>
    </td>
</tr>

