@props(['itemOptions' => [], 'item' => null, 'last' => false])
@php
    use Inside\Settings\Models\Setting;
    use Inside\Support\Str;
    use Illuminate\Support\Arr;
    use Inside\Content\Facades\Schema as InsideSchema;
    use Inside\Newsletters\Facades\UrlSigner;

    // Prepare options
    $imageStyle = $itemOptions['imageStyle'] ?? 'thumbnail';
    $leftLineColor = $itemOptions['leftLineColor'] ?? '#EA9675';

    $defaultCategoryColor = Setting::where('key', 'color_primary')->first()?->value ?? $itemOptions['defaultCategoryColor'] ?? '#A7A7A7';
    $categoryFieldName = $itemOptions['categoryFieldName'] ?? 'jobs_categories';
    $titleColor = $itemOptions['titleColor'] ??'#2C3E50';
    $categories = [];

    // Prepare color
    if (InsideSchema::hasField(class_to_type($item), $categoryFieldName) && $item->{Str::camel($categoryFieldName)} !== null) {
        $categoryFieldOptions = InsideSchema::getFieldOptions(class_to_type($item), $categoryFieldName);
        $categoryContent = Arr::first($categoryFieldOptions['target']);
        if ($categoryContent) {
            $contentCategories = $item->{Str::camel($categoryFieldName)};
            foreach ($contentCategories as $contentCategory) {
                 $categories[] = $contentCategory->title;
            }
        }
    }

    $modalOptions = $itemOptions['modal'] ?? [];

    $query = http_build_query([
        'modal' => $modalOptions['name'] ?? 'job',
        'size' => $modalOptions['size'] ?? 'm',
        'contentType' => $item->content_type,
        'uuid' => $item->uuid,
    ]);

    $link = $itemOptions['link']['sectionLinkUrl'] ?? 'jobs';

    if (!isset($options['preview'])) {
        $url = UrlSigner::signedRoute('newsletters.clicked', ['type' => $newsletter->content_type, 'newsletterUuid' => $newsletter->uuid, 'userUuid' => $user->uuid, 'redirect' => "$link?$query"]);
    } else {
        $url = url("$link?$query");
    }
@endphp
<tr>
    <td>
        <table class="document-container" cellpadding="0" cellspacing="0" border="0" style="width: 100%;">
            <tr>
                <td style="width: 6px;">
                    <span
                        style="display: block; width: 6px; height: 100%; background: {{ $leftLineColor }}; height: 60px;"></span>
                </td>
                <td style="width: 16px;" width="16px">
                    <span></span>
                </td>
                <td>
                    <table cellpadding="0" cellspacing="0" border="0">
                        <tr>
                            <td>
                                <a href="{{ $url }}" target="_blank" style="text-decoration: none;">
                                    <p style="color: {{ $titleColor }}; font-family: Arial; font-size: 14px; letter-spacing: 0; line-height: 16px; margin: 0; font-weight: bold;">
                                        {{ $item->title }}
                                    </p>
                                </a>
                            </td>
                        </tr>
                        <tr>
                            <td style="height: 8px;">
                                <span></span>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <p style="color: {{ $defaultCategoryColor }}; font-family: Arial; font-size: 14px; letter-spacing: 0; margin: 0;">{{ implode(', ', $categories) }}</p>
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>
    </td>
</tr>
@if(!$last)
    <tr>
        <td style="height: 16px;" width="16px">
            <span></span>
        </td>
    </tr>
@endif
