@props(['options' => []])
@php
    use Illuminate\Support\Carbon;use Inside\Support\Str;

    $logoUrl = $options['logoUrl'] ?? null;
    if ($logoUrl !== null && ! Str::startsWith($logoUrl, 'http')) {
        if (File::exists(cms_base_path($logoUrl))) {
            $logoUrl = url($logoUrl);
        } else {
            $logoUrl = null;
        }
    }
    $showLogo = $options['showLogo'] ?? ! is_null($logoUrl);
    $logoWidth =  $options['logoWidth'] ?? 205;
    $showDate =  $options['showDate'] ?? false;
    $dateColor =  $options['dateColor'] ?? '#a7a7a7';
    $dateFormat = $options['dateFormat'] ?? '%A %d %B %Y';
    $dateField = $options['dateField'] ?? null;

    $date = $dateField ? get_date($newsletter->{$dateField}) : now();
@endphp
<table cellspacing="0" cellpadding="0" border="0" width="100%">
    <tbody>
    <tr>
        <td style="padding-top:5px;padding-right:10px">
            <p style="font-family: Arial; font-size: 14px; color: {{ $dateColor }}; margin: 0;" align="right">
                {{ $title ?? ucwords($date->setTimezone('Europe/Paris')->formatLocalized($dateFormat)) }}
            </p>
        </td>
    </tr>
    </tbody>
</table>
