@props(['itemOptions' => [], 'item' =>null, 'last' => false])
@php
    use Illuminate\Support\Carbon;
    use Inside\Settings\Models\Setting;
    use Inside\Support\Str;
    use Illuminate\Support\Arr;
    use Inside\Content\Facades\Schema as InsideSchema;

    // Prepare options
    $imageStyle = $itemOptions['imageStyle'] ?? 'thumbnail';
    $showDate = $itemOptions['showDate'] ?? true;
    $dateFormat = $itemOptions['dateFormat'] ??'%d/%m/%Y';
    $dateColor = $itemOptions['dateColor'] ?? '#A7A7A7';
    $dateFieldName = $itemOptions['dateFieldName'] ?? 'published_at';
    $defaultImageActive = $itemOptions['defaultImageActive'] ?? true;
    $defaultImageUrl = $itemOptions['defaultImageUrl'] ?? (config('app.url') . '/vendor/maecia/inside-newsletters/resources/images/iln/default_thumbnail.png');
    $showCategoryTitle = $itemOptions['showCategoryTitle'] ?? false;
    $defaultCategoryColor = Setting::where('key', 'color_primary')->first()?->value ?? $itemOptions['defaultCategoryColor'] ?? '#EA9675';
    $categoryFieldName = $itemOptions['categoryFieldName'] ?? 'news_categories';
    $titleColor = $itemOptions['titleColor'] ??'#2C3E50';
    $showIntroduction = $itemOptions['showIntroduction'] ?? false;
    $introductionColor = $itemOptions['introductionColor'] ?? '#4D4D4D';
    $introductionLength = $itemOptions['introductionLength'] ?? 100;
    $introductionFieldName = $itemOptions['introductionFieldName'] ?? 'chapo';
    $showSections = $itemOptions['showSections'] ?? true;

    // Prepare categories if enabled
    if ($showCategoryTitle && InsideSchema::hasField(class_to_type($item), $categoryFieldName) && $item->{Str::camel($categoryFieldName)} !== null) {
        $categoryFieldOptions = InsideSchema::getFieldOptions(class_to_type($item), $categoryFieldName);
        $categoryContent = Arr::first($categoryFieldOptions['target']);
        $categories = [];
        if ($categoryContent) {
            $contentCategories = $item->{Str::camel($categoryFieldName)};
            if ($categoryFieldOptions['cardinality'] == 1) {
                $contentCategories = [$contentCategories];
            }
            foreach ($contentCategories->take(3) as $contentCategory) {
                $categories[] = [
                'title' => $contentCategory->title,
                'color' => ((InsideSchema::hasField($categoryContent, 'color') && $contentCategory->color !== null && !empty($contentCategory->color)) ? $contentCategory->color : $defaultCategoryColor),
                ];
            }
        }
    } else {
        $showCategoryTitle = false;
    }
    $body = preg_replace("/<img[^>]+\>/i", "(image) ", $item->image);
    $thumbnailUrl = newsletter_signed_url($user, $newsletter, $item, get_stylized_image_url($item, 'image', $imageStyle ?? 'thumbnail', true), $defaultImageUrl . '?'.time());
    $sections = collect();
    if ($showSections) {
        foreach (InsideSchema::getFieldListingOfType(class_to_type($item), 'section') as $sectionFieldName) {
            $fieldOptions = InsideSchema::getFieldOptions(class_to_type($item), $sectionFieldName);

            $sections = $sections->merge($item->{ Str::snake('section_'.$sectionFieldName) });
        }
    }
@endphp
<tr>
    <td>
        <table cellpadding="0" cellspacing="0" border="0" style="width: 100%;">
            @if($showDate)
                <tr>
                    <td>
                        <p style="color:  {{ $dateColor }}; font-family: Arial; font-size: 14px; letter-spacing: 0; margin: 0;">
                            {{ ucwords(get_date_in_user_timezone($item->{$dateFieldName})->formatLocalized($dateFormat)) }}</p>
                    </td>
                </tr>
            @endif
            <tr>
                <td style="height: 4px;">
                    <span></span>
                </td>
            </tr>
            <tr>
                <td>
                    <a href="{{ url(Arr::first($item->slug)) }}"
                       target="_blank" style="text-decoration: none;"><h2
                                style="color: {{ $titleColor }}; font-family: Arial; font-size: 22px; font-weight: bold; letter-spacing: 0; line-height: 21px; margin: 0;">
                            {{ $item->title }}</h2></a>
                </td>
            </tr>
            <tr>
                <td style="height: 16px;">
                    <span></span>
                </td>
            </tr>
            @if($defaultImageActive || strpos($thumbnailUrl, $defaultImageUrl) === false)
                <tr>
                    <td>
                        <img src="{{ $thumbnailUrl }}" alt="{{ $item->title }}"
                             style="display: block;max-width: 100%;height: auto;"/>
                    </td>
                </tr>
            @endif
            <tr>
                <td style="height: 16px;">
                    <span></span>
                </td>
            </tr>
            @if($showSections)
                @foreach($sections as $section)
                    @if(in_array(class_to_type($section), ['image', 'text', 'text_with_image']))
                        <x-dynamic-component component="{{  'iln::partials.sections.'.class_to_type($section)  }}"
                                             :item-options="$itemOptions" :item="$section" :last="$loop->last"/>
                    @endif
                @endforeach
            @endif
            <tr>
                <td>
                    <span
                            style="display: block; width: 100%; height: 1px; border-bottom: 5px dotted #a7a7a7;"></span>
                </td>
            </tr>
            <tr>
                <td style="height: 16px;">
                    <span></span>
                </td>
            </tr>
        </table>
    </td>
</tr>
