@php
    use Illuminate\Support\Carbon;
    use Inside\Newsletters\Facades\UrlSigner;

    if (!isset($options['preview'])) {
        $parsedUrl = parse_url($url);
        if (isset($parsedUrl['path'])) {
            $path = $parsedUrl['path'];
            $queryString = isset($parsedUrl['query']) ? '?' . $parsedUrl['query'] : '';
            $url = UrlSigner::signedRoute('newsletters.clicked', ['type' => $newsletter->content_type, 'newsletterUuid' => $newsletter->uuid, 'userUuid' => $user->uuid, 'redirect' => ltrim($path, '/') . $queryString]);
        }
    }
@endphp
<tr>
    <td>
        <table class="document-container" cellpadding="0" cellspacing="0" border="0" style="width: 100%;">
            <tr>
                <td style="width: 6px;">
                    <span
                        style="display: block; width: 6px; height: 100%; background: {{ $leftLineColor }}; height: 60px;"></span>
                </td>
                <td style="width: 24px;">
                    <span></span>
                </td>
                <td style="width: 18px;">
                    <a href="{{ $url }}" target="_blank" style="text-decoration: none;"><img src="{{ $logoUrl }}" alt/></a>
                </td>
                <td style="width: 16px;">
                    <span></span>
                </td>
                <td>
                    <table cellpadding="0" cellspacing="0" border="0">
                        <tr>
                            <td>
                                <a href="{{ $url }}" target="_blank" style="text-decoration: none;"><p style="color: {{ $titleColor }}; font-family: Arial; font-size: 14px; letter-spacing: 0; line-height: 16px; margin: 0;">
                                    {{ $item->title }}
                                </p></a>
                            </td>
                        </tr>
                        <tr>
                            <td style="height: 8px;">
                                <span></span>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <p style="color: {{ $dateColor }}; font-family: Arial; font-size: 14px; letter-spacing: 0; margin: 0;">{{ ucwords(get_date_in_user_timezone($item->{$dateFieldName})->formatLocalized($dateFormat)) }}</p>
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>
    </td>
</tr>
@if(!$last)
    <tr>
        <td style="height: 16px;">
            <span></span>
        </td>
    </tr>
@endif
