@props(['itemOptions' => [], 'item' => null, 'last' => false])
@php
    use Illuminate\Support\Carbon;
    use Inside\Support\Str;
    use Illuminate\Support\Arr;
    use Inside\Content\Facades\Schema as InsideSchema;

    // Prepare options
    $defaultBackgroundColor = $itemOptions['defaultBackgroundColor'] ?? '#F0F0F0';
    $backgroundColor = $item['backgroundColor'] ?? $defaultBackgroundColor;

    $defaultBackgroundImageUrl = $itemOptions['defaultBackgroundImageUrl'] ?? null;
    $backgroundImageUrl = $item['backgroundImageUrl'] ?? $defaultBackgroundImageUrl;

    $defaultTitleColor = $itemOptions['defaultTitleColor'] ?? '#2C3E50';
    $titleColor = $item['titleColor'] ?? $defaultTitleColor;

    $defaultValueColor = $itemOptions['defaultValueColor'] ?? '#2C3E50';
    $valueColor = $item['valueColor'] ?? $defaultValueColor;

    $value = $item['callback']() ?? 0;
    $titleStrKey = $item['titleStrKey'] ?? 'newsletter.activity_title';
@endphp
<table cellpadding="0" cellspacing="0" border="0" style="width: 100%;">
    <tr>
        <td>
            @if(is_null($backgroundImageUrl))
            <span style="display: block; background: {{ $backgroundColor }}; width: 80px; height: 80px; margin: auto;"></span>
            @else
            <x-iln::partials.box :imageUrl="$backgroundImageUrl" :backgroundColor="$backgroundColor" width="80px" height="80px" />
            @endif
        </td>
    </tr>
    <tr>
        <td style="height: 14px;">
            <span>&nbsp;</span>
        </td>
    </tr>
    <tr>
        <td>
            <p style="color: {{ $valueColor }}; font-family: Arial; font-size: 22px; font-weight: bold; letter-spacing: 0; line-height: 22px; text-align: center; margin: 0;">{{ $value }}</p>
        </td>
    </tr>
    <tr>
        <td>
            <p style="color: {{ $titleColor }}; font-family: Arial; font-size: 12px; letter-spacing: 0; line-height: 28px; text-align: center; margin: 0; text-transform: uppercase;">{{ __($titleStrKey) }}</p>
        </td>
    </tr>
</table>
