@props(['options' => []])
@php
    use Inside\Settings\Models\Setting;
    $backgroundColor = $options['backgroundColor'] ?? '#F0F0F0';
    $unsubscribeTextColor = $options['unsubscribeTextColor'] ?? '#818181';
    $unsubscribeTextStrKey = $options['unsubscribeTextStrKey'] ?? 'newsletter.unsubscribe.warning';
    $unsubscribeLinkUrl = $options['unsubscribeLinkUrl'] ?? '/profile/notifications';
@endphp
<table cellpadding="0" cellspacing="0" border="0" style="width: 100%; background: {{ $backgroundColor }};">
    <tr>
        <td style="height: 12px;">
            <span style="height: 12px;"></span>
        </td>
    </tr>

    @if (Setting::where('key', 'show_newsletter_button')->value('value'))
        <tr>
            <td>
                <p style="text-align: center; font-family: Arial; font-size: 12px; color: {{ $unsubscribeTextColor }};"><em>{!! __($unsubscribeTextStrKey, ['site' => config('app.name'), 'url' => url($unsubscribeLinkUrl)]) !!}</em></p>
            </td>
        </tr>
    @endif

    <tr>
        <td style="height: 12px;">
            <span style="height: 12px;"></span>
        </td>
    </tr>
</table>
