@props(['options' => []])
@php
    use Inside\Support\Str;
    $backgroundColor = $options['backgroundColor'] ?? '#FFFFF';
    $logoUrl = $options['logoUrl'] ?? '';
    if ($logoUrl !== null && ! Str::startsWith($logoUrl, 'http')) {
        if (File::exists(cms_base_path($logoUrl))) {
            $logoUrl = url($logoUrl);
        } else {
            $logoUrl = null;
        }
    }
    $sectionLinkUrl =  $options['sectionLinkUrl'] ?? '/';
    $sectionTextColor = $options['sectionTextColor'] ?? '#EB9D7E';
    $sectionLinkStrKey  = $options['sectionLinkStrKey'] ?? '';
@endphp
@if($options)
<table cellpadding="0" cellspacing="0" border="0" style="width: 100%; height: 120px; background: {{ $backgroundColor }};">
    <tr>
        <td style="width: 50%; padding-left: 10%;">
            <!-- Logo goes here -->
            <img src="{{ $logoUrl }}" alt="Your Logo" style="max-width: 100%; height: auto;">
        </td>
        <td style="width: 50%; text-align: right; padding-right: 10%;">
            <a href="{{ url($sectionLinkUrl) }}" style="text-decoration: none; display: inline-block; border: 1px solid #FFFFFF; border-radius: 18px; padding: 8px 25px;" target="_blank">
                <svg width="16px" height="17px" viewBox="0 0 16 17" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
                    <g id="💻-Maquettes---All" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                        <g id="Newsletter" transform="translate(-395.000000, -870.000000)">
                            <rect fill="#FFFFFF" x="0" y="0" width="690" height="1995"></rect>
                            <rect id="Rectangle-6" fill="#FFFFFF" x="10" y="-44" width="1644" height="3602"></rect>
                            <g id="Components/Link/LinkIconLeft" transform="translate(385.000000, 870.500000)" fill={{ $sectionTextColor }}>
                                <g id="Icon/Email" transform="translate(10.000000, 0.000000)">
                                    <path d="M9.33333333,13.3336667 C9.16266667,13.3336667 8.992,13.2683333 8.862,13.1383333 C8.60133333,12.8776667 8.60133333,12.4563333 8.862,12.1956667 L12.3906667,8.66633333 L2,8.66633333 C1.632,8.66633333 1.33333333,8.36833333 1.33333333,8.00033333 C1.33333333,7.63166667 1.632,7.33366667 2,7.33366667 L12.3906667,7.33366667 L8.862,3.805 C8.60133333,3.54433333 8.60133333,3.12233333 8.862,2.86166667 C9.12266667,2.60166667 9.544,2.60166667 9.80466667,2.86166667 L14.4713333,7.52833333 C14.536,7.593 14.584,7.667 14.6166667,7.74633333 C14.6486667,7.82366667 14.6666667,7.909 14.6666667,7.99833333 L14.6666667,8.00166667 C14.6666667,8.09166667 14.6486667,8.177 14.6166667,8.25433333 L14.6166667,8.255 L14.616,8.255 C14.5833333,8.33366667 14.5353333,8.407 14.4713333,8.47166667 C14.4706667,8.47166667 14.47,8.47233333 14.4693333,8.473 L9.80466667,13.1383333 C9.67466667,13.2683333 9.504,13.3336667 9.33333333,13.3336667" id="Fill-1"></path>
                                </g>
                            </g>
                        </g>
                    </g>
                </svg>
                <span style="color: {{ $sectionTextColor }}; font-family: Arial; font-size: 14px; letter-spacing: 0; line-height: 16px; display: inline-block; vertical-align: middle;">{{ __($sectionLinkStrKey) }}</span>
            </a>
        </td>
    </tr>
</table>
@endif
