@if(!is_null($backgroundImageUrl) && !$backgroundImageAsCover)
    <x-iln::partials.banner-as-image
        :backgroundImageUrl="$backgroundImageUrl"
        :backgroundColor="$backgroundColor"
        :bannerImageTextColor="$bannerImageTextColor"
        :bannerWidth="$bannerWidth"
        :bannerTitle="$bannerTitle"
        :bannerSubTitle="$bannerSubTitle"
    />
@else
    @if(!is_null($backgroundImageUrl))
        <table class="container" role="presentation" cellpadding="0" cellspacing="0" border="0" width="100%">
            <tr>
                <td>
            <!--[if gte mso 9]>
            <v:rect xmlns_v="urn:schemas-microsoft-com:vml" fill="true" stroke="false" style="width:{{ $bannerWidth ?? 600 }}px; background-color:{{ $backgroundColor }};">
                <v:fill type="frame" src="{{ $backgroundImageUrl }}" />
                <v:textbox style="mso-fit-shape-to-text:true" inset="0,0,0,0">
            <![endif]-->
                    <div>
                        <table role="presentation" cellpadding="0" cellspacing="0" border="0" width="100%"
                               height="{{ $height }}">
                            <tr>
                                <td style="background: url({{ $backgroundImageUrl }}) {{ $backgroundColor }}; background-size:cover; background-position:center;">
                                    @endif
                                    <table cellpadding="0" cellspacing="0" border="0"
                                           style="@if(is_null($backgroundImageUrl)) background: {{ $backgroundColor }}; @endif width: 100%; text-align: center;">
                                        <tr>
                                            <td style="height: 24px;">
                                                <span></span>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <h1 style="color: {{ $titleColor }}; font-family: Arial; font-size: 24px; line-height: 1; margin: 0;">{{ $title }}</h1>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="height: 12px;">
                                                <span></span>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <p style="color: {{ $subTitleColor }}; font-family: Arial; font-size: 14px; line-height: 1; margin: 0;">{{ $subTitle }}</p>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="height: 24px;">
                                                <span></span>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td align="center">
                                                <table cellpadding="0" cellspacing="0" border="0">
                                                    <tr>
                                                        <td style="width: 700px; height: 32px; background: #fff;">
                                                            <span style="height: 35px;"></span>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                                    </table>
                                    @if(!is_null($backgroundImageUrl))
                                </td>
                            </tr>
                        </table>
                    </div>
                    <!--[if gte mso 9]>
                    </v:textbox>
                    </v:rect>
                    <![endif]-->
                </td>
            </tr>
        </table>
    @endif
@endif
