<html>
<head>
    <script
        src="{{ url('vendor/maecia/inside-newsletters/resources/assets/js/alpine.min.js') }}"
        defer=""
    ></script>
    <style>
        .modal {
            transition: opacity 0.25s ease;
        }

        body.modal-active {
            overflow-x: hidden;
            overflow-y: visible !important;
        }
    </style>
    <meta
        name="viewport"
        content="width=device-width, initial-scale=1, shrink-to-fit=no"
    />
    <link
        rel="stylesheet"
        href="{{ url('vendor/maecia/inside-newsletters/resources/assets/css/tailwind.min.css') }}"
    />
    <title>Gestionnaire de newsletters</title>
</head>
<body>
<div class="bg-gray-100 py-6 min-h-screen">
    <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
        <div class="flex flex-col">
            <div class="-my-2 overflow-x-auto sm:-mx-6 lg:-mx-8">
                <div
                    class="py-2 align-middle inline-block min-w-full sm:px-6 lg:px-8"
                >
                    <div
                        class="shadow overflow-hidden border-b border-gray-200 sm:rounded-lg"
                    >
                        <table
                            class="min-w-full divide-y divide-gray-200"
                        >
                            <thead class="bg-gray-50">
                            <tr>
                                <th
                                    scope="col"
                                    class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider"
                                >
                                    Nom de la newsletter
                                </th>
                                <th
                                    scope="col"
                                    class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider"
                                >
                                    Type de contenu
                                </th>
                                <th
                                    scope="col"
                                    class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider"
                                >
                                    #
                                </th>
                            </tr>
                            </thead>
                            <tbody class="bg-white divide-y divide-gray-200">
                            @foreach($newsletters as $newsletter)
                                <tr>
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <div class="flex items-center">
                                            <div class="ml-4">
                                                <div
                                                    class="text-sm font-medium text-gray-900 uppercase"
                                                >{{ $newsletter['name'] }}
                                                    <span
                                                        class="inline-flex items-center justify-center px-2 py-1 text-xs font-bold leading-none text-indigo-100 bg-indigo-700 rounded">{{ $newsletter['system'] }}</span>
                                                </div>
                                                <div
                                                    class="text-sm text-gray-500"
                                                >{{ $newsletter['file'] }}</div>
                                            </div>
                                        </div>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <div class="px-6 py-2 whitespace-no-wrap text-sm leading-5 text-gray-900 table-cell  text-left">
                                        @if(\Inside\Content\Facades\Schema::hasContentType($newsletter['type']))
                                            <a href="{{ url('admin/structure/types/manage/'.$newsletter['type'].'/fields') }}"
                                               target="_blanc">{{ $newsletter['type'] }}</a>
                                        @else
                                            {{ $newsletter['type'] }} <span
                                                class="inline-flex items-center justify-center px-2 py-1 mr-2 text-xs font-bold leading-none text-red-100 bg-red-600 rounded-full">Nouveau</span>
                                        @endif
                                        </div>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <div class="flex space-x-1 justify-around">
                                            <a href="{{ route('newsletters.dashboard.edit', ['name' => $newsletter['system']]) }}" class="p-1 text-blue-600 hover:bg-blue-600 hover:text-white rounded">
                                                <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                                                    <path d="M13.586 3.586a2 2 0 112.828 2.828l-.793.793-2.828-2.828.793-.793zM11.379 5.793L3 14.172V17h2.828l8.38-8.379-2.83-2.828z"></path>
                                                </svg>
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
</body>
</html>
