@php
    use Inside\Facades\Package;
    use Inside\Content\Facades\Schema;
    use Inside\Support\Str;
    use Inside\Content\Models\Content;
    use Symfony\Component\HttpFoundation\File\MimeType\MimeTypeGuesser;

    if (!function_exists('inside_document_logo')) {
        function inside_document_logo(Content $document): string {
            $type = class_to_type($document);
            $fileType = 'other';
            // Déterminer l'extension
             if (Str::endsWith($type, '_link') && Schema::hasField($type, 'link') && $document->link !== null) {
                $fileType = 'link';
            } else if(Schema::hasField($type, 'file')&& $document->file !== null) {
                 $disk = Storage::disk('local');
                 // Récupere l'extension
                 if ($disk->exists($document->file)) {
                    $realPath = $disk->path($document->file);
                    MimeTypeGuesser::reset();
                    $guesser           = MimeTypeGuesser::getInstance();
                    $mime = $guesser->guess($realPath);
                    switch($mime)
                    {
                        case 'application/vnd.ms-excel':
                        case 'application/msexcel':
                        case 'application/x-msexcel':
                        case 'zz-application/zz-winassoc-xls':
                            $fileType = 'excel';
                            break;
                        case 'image/jpeg':
                        case 'image/pjpeg':
                        case 'image/png':
                        case 'image/tiff':
                        case 'image/gif':
                        case 'image/bmp':
                        case 'image/x-bmp':
                        case 'image/x-ms-bmp':
                            $fileType = 'image';
                            break;
                        case 'application/pdf':
                        case 'application/acrobat':
                        case 'application/nappdf':
                        case 'application/x-pdf':
                        case 'image/pdf':
                            $fileType = 'pdf';
                            break;
                        case 'application/vnd.ms-powerpoint':
                        case 'application/mspowerpoint':
                        case 'application/powerpoint':
                        case 'application/x-mspowerpoint':
                            $fileType = 'powerpoint';
                            break;
                        case 'text/plain':
                            $fileType = 'text';
                            break;
                        case 'video/mp4':
                        case 'video/mp4v-es':
                        case 'video/x-m4v':
                        case 'video/x-matroska':
                        case 'video/quicktime':
                        case 'video/avi':
                        case 'video/divx':
                        case 'video/msvideo':
                        case 'video/vnd.divx':
                        case 'video/x-avi':
                        case 'video/x-msvideo':
                            $fileType = 'video';
                            break;
                        case 'application/msword':
                        case 'application/vnd.ms-word':
                        case 'application/x-msword':
                        case 'zz-application/zz-winassoc-doc':
                            $fileType = 'word';
                            break;
                        case 'application/zip':
                        case 'application/x-zip':
                        case 'application/x-zip-compressed':
                            $fileType = 'zip';
                            break;
                    }
                }
            }

            return config('app.url') .'/vendor/maecia/inside-newsletters/resources/images/documents/'.$fileType.'.jpg';
        }
    }

    if (!function_exists('inside_document_url')) {
        /**
        * @param string $gedSlug
        * @param \Inside\Content\Models\Content $document
        * @param string|null $parentFieldName
        * @return string
        */
        function inside_document_url(string $gedSlug, Content $document, ?string $parentFieldName = null): string {
            $type = class_to_type($document);

            // C'est un document lien
            if (Str::endsWith($type, '_link') && Schema::hasField($type, 'link')) {
                return $document->link ?? '#';
            }
            $parentFieldName = $parentFieldName ?? 'folders';
            $fieldOptions = Schema::getFieldOptions($type, $parentFieldName);

            $parent = $document->{Str::camel($parentFieldName)};
            if ($parent !== null) {
                $parent = (isset($fieldOptions['cardinality']) && $fieldOptions['cardinality'] == 1) ? $parent : $parent->first();
            }

            if (Package::has('inside-dms')) {
                // Gedv2 !
                return config('app.url') . '/' . $gedSlug . '?folder=' . $parent->uuid . '#&modal/' . $type . '/' . $document->uuid;
            }
            return config('app.url') . '/' . $gedSlug . '#&ged/' . $parent->uuid . '&modal/' . $type . '/' . $document->uuid;
        }
        return '#';
    }
@endphp
<!-- BEGIN DOCUMENT LINE //-->
<tr style="border-collapse:collapse">
    <td align="left" style="padding:0;Margin:0;padding-top:10px;padding-bottom:10px">

        <table style="width:600px" cellpadding="0" cellspacing="0">
            <tr>
                <td style="width:88px" valign="top">
        <table class="es-left" cellspacing="0" cellpadding="0" align="left"
               style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:left">
            <tr class="es-mobile-hidden" style="border-collapse:collapse">
                <td class="es-m-p20b" align="left" style="padding:0;Margin:0;width:68px">
                    <table width="100%" cellspacing="0" cellpadding="0" role="presentation"
                           style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                        <tr style="border-collapse:collapse">
                            <td align="left" style="padding:0;Margin:0"><p
                                    style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family:arial, 'helvetica neue', helvetica, sans-serif;line-height:21px;color:#000000;font-size:14px">
                                    <br></p></td>
                        </tr>
                    </table>
                </td>
                <td class="es-hidden" style="padding:0;Margin:0;width:20px"></td>
            </tr>
        </table>
        </td>
        <td style="width:65px"  valign="top">
        <table class="es-left" cellspacing="0" cellpadding="0" align="left"
               style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:left;">
            <tr style="border-collapse:collapse;">
                <td class="es-m-p20b" align="left"
                    style="padding:0;Margin:0;width:45px">
                    <table width="100%" cellspacing="0" cellpadding="0"
                           style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;">
                        <tr style="border-collapse:collapse;">
                            <td align="left"
                                style="padding:0;Margin:0;"><a
                                    target="_blank" href="{{ inside_document_url($gedSlug, $document) }}"
                                    style="-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family:arial, 'helvetica neue', helvetica, sans-serif;font-size:14px;text-decoration:none;color:#1F4D8B;">
                                    <img src="{{ inside_document_logo($document) }}"
                                         alt
                                         style="display:block;border:0;outline:none;text-decoration:none;-ms-interpolation-mode:bicubic;"
                                         width="28"> </a></td>
                        </tr>
                    </table>
                </td>
                <td class="es-hidden" style="padding:0;Margin:0;width:20px"></td>
            </tr>
        </table>
        </td>
        <td style="width:360px" valign="top">
        <table class="es-left" cellspacing="0" cellpadding="0" align="left"
               style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:left">
            <tr style="border-collapse:collapse">
                <td class="es-m-p20b" align="left" style="padding:0;Margin:0;width:360px">
                    <table width="100%" cellspacing="0" cellpadding="0" role="presentation"
                           style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                        <tr style="border-collapse:collapse">
                            <td align="left" style="padding:0;Margin:0;padding-top:5px"><p
                                    style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family:arial, 'helvetica neue', helvetica, sans-serif;line-height:20px;color:#003A7B;font-size:17px">
                                <a target="_blank"
                                       style="-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family:arial, 'helvetica neue', helvetica, sans-serif;font-size:17px;text-decoration:none;color:#003A7B;line-height:20px;"
                                       href="{{ inside_document_url($gedSlug, $document) }}">{{ $document->title }}</a>
                                </p></td>
                        </tr>
                        <tr style="border-collapse:collapse">
                            <td align="left" style="padding:0;Margin:0"><p
                                    style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family:arial, 'helvetica neue', helvetica, sans-serif;line-height:21px;color:#727272;font-size:14px">
                                    {{ $date ?? ucwords(get_date_in_user_timezone($document->created_at)->formatLocalized("%d %B %Y")) }}</p>
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>
        </td>
        <td style="width:20px"></td>
        <td style="width:67px" valign="top">
        <table class="es-right" cellspacing="0" cellpadding="0" align="right"
               style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:right">
            <tr class="es-mobile-hidden" style="border-collapse:collapse">
                <td align="left" style="padding:0;Margin:0;width:67px">
                    <table width="100%" cellspacing="0" cellpadding="0" role="presentation"
                           style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                        <tr style="border-collapse:collapse">
                            <td align="left" style="padding:0;Margin:0"><p
                                    style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family:arial, 'helvetica neue', helvetica, sans-serif;line-height:21px;color:#333333;font-size:14px">
                                    <br></p></td>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>
        </td></tr></table>
    </td>
</tr>
<!-- END DOCUMENT LINE //-->
