<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTestEmailsTable extends Migration
{
    public function up(): void
    {
        if (Schema::hasTable('test_emails')) {
            Schema::dropIfExists('test_emails');
        }

        Schema::create('test_emails', function (Blueprint $table) {
            $table->uuid('uuid')->primary();
            $table->string('email')->unique();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('test_emails');
    }
}
