<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Content\Facades\Schema;

class AddTitleForBannerAndLogoInNewsletter extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $fields = [
            'nl_banner' => [
                'fr' => 'Bannière',
                'en' => 'Banner',
                'de' => 'Banner',
                'es' => 'Pancarta',
                'pt' => 'Banner',
                'nl' => 'Banner',
            ],
            'nl_logo' => [
                'fr' => 'Logo',
                'en' => 'Logo',
                'de' => 'Logo',
                'es' => 'Logotipo',
                'pt' => 'Logotipo',
                'nl' => 'Logo',
            ]
        ];

        collect(data_get(config('newsletters'), 'types'))
            ->keys()
            ->filter(fn (string $type) => Schema::hasContentType($type))
            ->each(fn (string $type) => collect($fields)->each(
                fn ($title, $fieldName) => $bridge->contentTypeUpdateField(
                    type: $type,
                    fieldName: $fieldName,
                    options: [
                        'name' => $fieldName,
                        'required' => false,
                        'title' => $title,
                        'widget' => [
                            'type' => BridgeContentType::IMAGE_WIDGET,
                            'settings' => [
                                'progress_indicator' => 'throbber',
                                'preview_image_style' => 'thumbnail',
                            ],
                            'hidden' => false,
                            'weight' => 1,
                        ],
                        'type' => BridgeContentType::IMAGE_FIELD,
                    ],
                    weight: $fieldName === 'nl_logo' ? 2 : 1
                )
            ));
    }
}
