<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema;
use Inside\Host\Bridge\BridgeContentType;
use Illuminate\Support\Facades\Artisan;

class HideLogoBannerNewsletterSettings extends Migration
{
    private const FIELDS = [
        'nl_banner',
        'nl_logo'
    ];

    public function up(): void
    {
        $bridge = new BridgeContentType();

        collect(data_get(config('newsletters'), 'types'))
            ->keys()
            ->filter(fn (string $type) => Schema::hasContentType($type) && Schema::hasField($type, 'nl_banner') && Schema::hasField($type, 'nl_logo'))
            ->each(fn (string $type) => collect(self::FIELDS)->each(
                fn ($fieldName) => $bridge->contentTypeUpdateField(
                    type: $type,
                    fieldName: $fieldName,
                    options: [
                        'name' => $fieldName,
                        'required' => false,
                        'widget' => [
                            'type' => BridgeContentType::IMAGE_WIDGET,
                            'settings' => [
                                'progress_indicator' => 'throbber',
                                'preview_image_style' => 'thumbnail',
                            ],
                            'hidden' => true,
                            'weight' => 1,
                        ],
                        'type' => BridgeContentType::IMAGE_FIELD,
                    ],
                    weight: 1
                )
            ));
    }
}
