<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Arr;
use Inside\Host\Bridge\BridgeContentType;

class DisableNewslettersStatus extends Migration
{
    public function up(): void
    {
        $newsletters = collect(config('newsletters.types'))->pluck('notification.view');
        $bridge = new BridgeContentType();
        if ($newsletters->count() === 1) {
            $newsletters = collect([config('app.code')]);
        }

        $newsletters->each(function (string $newsletter) use ($bridge) {
            $newsletterFileName = str($newsletter)->after('_');
            $configPath = back_path("resources/newsletters/".$newsletterFileName.".php");

            if (!file_exists($configPath)) {
                return;
            }

            $config = include $configPath;
            $newsletterType = Arr::get($config, '_meta.type');
            $bridge->changeFieldFormOptions($newsletterType, 'status', false, 'group_options');
        });
    }
}
