<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema;
use Inside\Host\Bridge\BridgeContentType;
use Illuminate\Support\Facades\Artisan;

class AddNewsletterSettings extends Migration
{
    private const DESCRIPTIONS = [
        'fr' => "L’image par défaut sera l’image présente dans les paramètres avancés de l’intranet. Si vous ajoutez une autre image ici elle écrasera l’image des paramètres avancés sur cette newsletter",
        'en' => "The default image will be the one present in the advanced settings of the intranet. If you add another image here, it will override the image from the advanced settings on this newsletter.",
        'de' => "Das Standardbild ist das im erweiterten Intranet-Setup. Wenn Sie hier ein anderes Bild hinzufügen, wird das Bild der erweiterten Einstellungen in diesem Newsletter überschrieben.",
        'es' => "La imagen predeterminada será la que esté presente en la configuración avanzada del intranet. Si añades otra imagen aquí, sobrescribirá la imagen de la configuración avanzada en este boletín.",
        'pt' => "A imagem padrão será a presente nas configurações avançadas da intranet. Se adicionar outra imagem aqui, ela substituirá a imagem das configurações avançadas nesta newsletter.",
        'nl' => "De standaardafbeelding is de afbeelding die aanwezig is in de geavanceerde instellingen van het intranet. Als u hier een andere afbeelding toevoegt, overschrijft deze de afbeelding uit de geavanceerde instellingen op deze nieuwsbrief."
    ];
    private const FIELDS = [
        'nl_banner' => [
            'fr' => 'Bannière',
            'en' => 'Banner',
            'de' => 'Banner',
            'es' => 'Pancarta',
            'pt' => 'Banner',
            'nl' => 'Banner',
        ],
        'nl_logo' => [
            'fr' => 'Logo',
            'en' => 'Logo',
            'de' => 'Logo',
            'es' => 'Logotipo',
            'pt' => 'Logotipo',
            'nl' => 'Logo',
        ],
    ];

    public function up(): void
    {
        $bridge = new BridgeContentType();

        collect(data_get(config('newsletters'), 'types'))
            ->keys()
            ->filter(fn (string $type) => Schema::hasContentType($type))
            ->each(fn (string $type) => collect(self::FIELDS)->each(
                fn ($fieldTitles, $fieldName) => $bridge->contentTypeCreateOrUpdateField(
                    type: $type,
                    fieldName: $fieldName,
                    options: [
                        'name' => $fieldName,
                        'searchable' => false,
                        'translatable' => true,
                        'search_result_field' => false,
                        'searchable_filter' => false,
                        'required' => false,
                        'weight' => 1,
                        'title' => $fieldTitles,
                        'description' => self::DESCRIPTIONS,
                        'widget' => [
                            'type' => BridgeContentType::IMAGE_WIDGET,
                            'settings' => [
                                'progress_indicator' => 'throbber',
                                'preview_image_style' => 'thumbnail',
                            ],
                            'weight' => 1,
                        ],
                        'type' => BridgeContentType::IMAGE_FIELD,
                        'settings' => [
                            'uri_scheme' => 'public',
                            'default_image' => [
                                'uuid' => '',
                                'alt' => '',
                                'title' => '',
                                'width' => null,
                                'height' => null,
                            ],
                            'target_type' => 'file',
                            'display_field' => false,
                            'display_default' => false,
                            'cardinality' => 1,
                        ],
                    ],
                    weight: 1
                )
            ));

        Artisan::call('models:rebuild');
        Artisan::call('inside:newsletter:setup:settings');
    }
}
