<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateNewslettersStatistics extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (Schema::hasTable('inside_newsletters_statistics')) {
            return;
        }

        Schema::create('inside_newsletters_statistics', function (Blueprint $table) {
            $table->increments('id');
            $table->string('newsletters_uuid');
            $table->uuid('user_uuid');
            $table->string('statistic_type');
            $table->timestamp('created_at')->useCurrent();
            $table->foreign('user_uuid')
                ->references('uuid')
                ->on('inside_users')
                ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('inside_newsletters_statistics');
    }
}
