<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Inside\Notify\Models\NotificationType;

class CreateUnsubscriptionsTable extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasTable('inside_newsletters_unsubscriptions')) {
            Schema::create('inside_newsletters_unsubscriptions', function (Blueprint $table) {
                $table->string('type');
                $table->uuid('user_uuid');
                $table->foreign('user_uuid')->references('uuid')->on('inside_users')->onDelete('cascade');
            });

            Schema::table(
                'inside_newsletters_unsubscriptions',
                function (Blueprint $table) {
                    $table->index(['type', 'user_uuid']);
                }
            );
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('inside_newsletters_unsubscriptions');
    }
}
