<?php

declare(strict_types=1);

namespace Inside\Movements\Listeners;

use Inside\Content\Events\ContentFullyInsertedEvent;
use Inside\Content\Models\Contents\Users;
use Inside\Movements\Contracts\UsersMovementsGenerator;

final class UsersCreatedListener
{
    public function __construct(
        private UsersMovementsGenerator $usersMovementsGenerator,
    ) {
    }

    public function handle(ContentFullyInsertedEvent $event): void
    {
        $model = $event->model;

        if (! $model instanceof Users) {
            return;
        }

        $this->usersMovementsGenerator->autoGenerateUserMovements($model);
    }
}
