<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\MovementsCategories;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Migrations\CreateContentTypes;

class UpdateMovementsCategoriesContentType extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->migrateContent('movements_categories');

        $categories = [
            [
                'template' => 'arrival',
                'title' => [
                    'fr' => 'Arrivée',
                    'en' => 'Arrival',
                    'es' => 'Incorporación',
                    'de' => 'Eintritt',
                ],
                'button_text' => [
                    'fr' => 'Bienvenue',
                    'en' => 'Welcome',
                    'es' => 'Bienvenido',
                    'de' => 'Willkommen',
                ],
            ],
            [
                'template' => 'nomination',
                'title' => [
                    'fr' => 'Nomination',
                    'en' => 'Nomination',
                    'es' => 'Nominación',
                    'de' => 'Nominierung',
                ],
                'button_text' => [
                    'fr' => 'Félicitations',
                    'en' => 'Congratulations',
                    'es' => 'Felicidades',
                    'de' => 'Glückwunsch',
                ],
            ],
        ];

        $bridge = new BridgeContent();
        foreach ($categories as $category) {
            foreach (list_languages() as $langcode) {
                $uuid = MovementsCategories::where(['template' => $category['template'], 'langcode' => $langcode])->first()?->uuid;

                if (! $uuid) {
                    continue;
                }

                $data = collect($category)
                    ->map(function ($item) use ($langcode) {
                        if (! is_array($item)) {
                            return $item;
                        }

                        return $item[$langcode] ?? $item['en'];
                    })
                    ->all();

                $data['uuid'] = $uuid;

                $bridge->contentUpdate('movements_categories', $data);
            }
        }

        $this->finishUp();
    }
}
