<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema;
use Inside\Content\Facades\Schema as InsideSchema;
use Inside\Host\Bridge\BridgeContent;
use Inside\Content\Models\Contents\Custom;

class CreateMovementsDefaultCustomPage extends Migration
{
    public function up(): void
    {
        $languages = list_languages();
        $data = [
            'fr' => [
                'title' => 'Mouvements',
                'introduction' => 'Retrouvez tous les mouvements'
            ],
            'en' => [
                'title' => 'Movements',
                'introduction' => 'Find all movements'
            ],
            'de' => [
                'title' => 'Bewegungen',
                'introduction' => 'Finde alle Bewegungen'
            ],
            'es' => [
                'title' => 'Movimientos',
                'introduction' => 'Encuentra todos los movimientos'
            ],
        ];

        if (!InsideSchema::hasModel('custom')) {
            return;
        }

        $bridge = new BridgeContent();

        $defaultLangcode = env('APP_LOCALE');

        $basePage = Custom::query()->where('langcode', $defaultLangcode)->where('title', $data[$defaultLangcode]['title'])->first();

        if (!$basePage) {
            $customData = [
                'langcode' => $defaultLangcode,
                'title' => $data[$defaultLangcode]['title'],
                'custom_slug' => 'newcomers'
            ];

            $fields = ['introduction', 'custom_introduction'];

            foreach ($fields as $field) {
                if (Schema::hasField('custom', $field)) {
                    $customData[$field] = $data[$defaultLangcode]['introduction'];
                }
            }

            $uuid = $bridge->contentInsert('custom', $customData);

            $basePage = Custom::find($uuid);
        }

        foreach ($languages as $langcode) {
            if ($langcode === $defaultLangcode) {
                continue;
            }

            $bridge->contentInsert('custom', [
                'langcode' => $langcode,
                'uuid_host' => $basePage->uuid_host,
                'title' => $data[$langcode]['title'],
                'introduction' => $data[$langcode]['introduction'],
                'custom_slug' => 'newcomers',
            ]);
        }
    }
}
