<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Content\Models\Contents\MovementsCategories;
use Inside\Host\Bridge\BridgeContent;

class CreateMovementsCategoriesContents extends Migration
{
    private ?BridgeContent $bridgeContent = null;

    public function getBridge(): ?BridgeContent
    {
        return $this->bridgeContent;
    }

    protected function createCategory(array $data, string $langcode): ?string
    {
        $existing = MovementsCategories::query()
            ->where('langcode', $langcode)
            ->where('template', $data['template'])
            ->first();

        if ($existing instanceof MovementsCategories) {
            return $existing->uuid;
        }

        $data['langcode'] = $langcode;

        return $this->getBridge()?->contentInsert('movements_categories', $data);
    }

    public function up(): void
    {
        Artisan::call('models:rebuild');

        $this->bridgeContent = new BridgeContent();

        $locale = config('app.locale');
        $languages = collect(list_languages())->reject($locale);

        $categories = [
            'arrival' => [
                'fr' => 'Arrivée',
                'en' => 'Arrival',
                'es' => 'Incorporación',
                'de' => 'Eintritt',
                'pt' => 'Chegada',
                'nl' => 'Aankomst',
            ],
            'nomination' => [
                'fr' => 'Nomination',
                'en' => 'Nomination',
                'es' => 'Nominación',
                'de' => 'Nominierung',
                'pt' => 'Nomeação',
                'nl' => 'Benoeming',
            ],
        ];

        foreach ($categories as $template => $titles) {
            $data = [
                'title' => $titles[$locale] ?? $titles['en'],
                'template' => $template,
            ];

            $original = $this->createCategory($data, $locale);
            $original = MovementsCategories::find($original);

            if (! $original instanceof MovementsCategories) {
                continue;
            }

            $data['uuid_host'] = $original->uuid_host;

            foreach ($languages as $language) {
                $data['title'] = $titles[$language] ?? $original->title;
                $this->createCategory($data, $language);
            }
        }
    }
}
