<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'movements_categories',
        'translatable' => (count(list_languages()) > 1),
        'searchable' => false,
        'global_searchable' => false,
        'aliasable' => false,
        'permissible' => true,
        'categorizable' => true,
        'listing_type' => 'hidden',
        'title' => [
            'fr' => 'Catégorie de mouvement',
            'en' => 'Movement Category',
            'es' => 'Categoría de movimiento',
            'de' => 'Bewegungskategorie',
            'pt' => 'Categoria de Movimento',
            'nl' => 'Bewegingscategorie',
        ],
    ],
    'fields' => [
        [
            'name' => 'template',
            'searchable' => false,
            'translatable' => false,
            'default' => null,
            'search_result_field' => true,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Modèle',
                'en' => 'Template',
                'es' => 'Plantilla',
                'de' => 'Vorlage',
                'pt' => 'Modelo',
                'nl' => 'Sjabloon',
            ],
            'description' => [],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 1,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
    ],
];
