<?php

declare(strict_types=1);

namespace Inside\Movements\Providers;

use Inside\Content\Events\ContentFullyInsertedEvent;
use Inside\Movements\Contracts\UsersMovementsGenerator as UsersMovementsGeneratorContract;
use Inside\Movements\Events\CongratulateUserEvent;
use Inside\Movements\Listeners\CongratulateUserListener;
use Inside\Movements\Listeners\UsersCreatedListener;
use Inside\Movements\Services\UsersMovementsGenerator;
use Inside\Support\EventServiceProvider as BaseServiceProvider;

class MovementsServiceProvider extends BaseServiceProvider
{
    protected array $listen = [
        CongratulateUserEvent::class => [
            CongratulateUserListener::class,
        ],
        ContentFullyInsertedEvent::class => [
            UsersCreatedListener::class,
        ],
    ];

    public array $bindings = [
        UsersMovementsGeneratorContract::class => UsersMovementsGenerator::class,
    ];

    public function register(): void
    {
        $this->mergeConfigFrom(__DIR__.'/../../config/movements.php', 'movements');
    }
}
