<?php

namespace Inside\Movements\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Inside\Content\Models\Contents\MovementsCategories;
use Inside\Movements\Events\CongratulateUserEvent;
use Inside\Notify\Listeners\BaseNotificationListener;
use Inside\Notify\Models\NotificationType;

class CongratulateUserListener extends BaseNotificationListener implements ShouldQueue
{
    /**
     * @param CongratulateUserEvent $event
     * @return void
     */
    public function handle(CongratulateUserEvent $event): void
    {
        $category = MovementsCategories::find($event->categoryUuid);

        $template = $category?->template ?? $event->template ?? 'default';

        $type = NotificationType::where('event', CongratulateUserEvent::class)
            ->where('action', $template)
            ->first();

        if (! $type instanceof NotificationType) {
            return;
        }

        $this->when = $this->getInterval($type);
        $this->route = $event->toUser;
        $this->notify(
            $type,
            $event->toUser,
            null,
            [
                'from' => $event->fromUser->uuid,
                'button_text' => $category?->button_text ?? null,
            ]
        );
    }
}
