<?php

namespace Inside\Movements\Http\Controllers;

use Exception;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Inside\Authentication\Models\User;
use Inside\Movements\Events\CongratulateUserEvent;
use Laravel\Lumen\Routing\Controller;

class MovementsController extends Controller
{
    /**
     * @param Request $request
     * @param string $user
     * @return JsonResponse
     * @throws Exception
     */
    public function congratulate(Request $request, string $user): JsonResponse
    {
        /** @var User $user */
        $user = User::findOrFail($user);
        /** @var User $me */
        $me = Auth::user();

        if (! $request->has('template') && ! $request->has('category_uuid')) {
            throw new Exception("need template or category_uuid to send notification");
        }

        if (! $me instanceof User) {
            throw new Exception('unauthenticated');
        }

        $template = $request->get('template');
        $categoryUuid = $request->get('category_uuid');

        if ($user->uuid !== $me->uuid) {
            CongratulateUserEvent::dispatch($me, $user, $template, $categoryUuid);
        }

        return response()->json([
            'success' => true,
        ]);
    }
}
