<?php

namespace Inside\Movements\Events;

use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Queue\SerializesModels;
use Inside\Authentication\Models\User;
use Inside\Events\Dispatchable;

class CongratulateUserEvent implements ShouldBroadcast
{
    use InteractsWithSockets;
    use SerializesModels;
    use Dispatchable;

    public function __construct(
        public User $fromUser,
        public User $toUser,
        public ?string $template = null,
        public ?string $categoryUuid = null,
    ) {
    }

    public function broadcastOn(): PrivateChannel
    {
        return new PrivateChannel('inside.congratulation.'.$this->toUser);
    }

    public function broadcastAs(): string
    {
        return 'inside.congratulation';
    }
}
