<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Movements\Events\CongratulateUserEvent;
use Inside\Notify\Models\NotificationType;

final class CreateDefaultMovementsNotificationType extends Migration
{
    public function up(): void
    {
        NotificationType::firstOrCreate(
            [
                'via' => 'web',
                'default' => false,
                'event' => CongratulateUserEvent::class,
                'model' => null,
                'type' => 'system',
                'action' => 'default',
                'condition' => null,
                'multiple' => false,
                'language' => true,
                'profile' => false,
            ],
            [
                'data' => [
                    'title' => 'notifications.movements.congratulate.default.title',
                    'description' => 'notifications.movements.congratulate.default.description',
                    'text' => 'notifications.movements.congratulate.default.text',
                ],
            ]
        );
    }
}
