<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema;
use Inside\Content\Models\Contents\Movements;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;

class RefactoFieldUsers extends Migration
{
    public function up(): void
    {
        if (Schema::hasField('movements', 'users')) {
            $movements = Movements::all();

            $bridgeType = new BridgeContentType();
            $bridge = new BridgeContent();

            $bridgeType->contentTypeCreateOrUpdateField('movements', 'movements_users', [
                'name' => 'movements_users',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => true,
                'search_filter' => false,
                'required' => true,
                'weight' => 0,
                'title' => [
                    'fr' => 'Utilisateur',
                    'en'  => 'User',
                    'es'  => 'Usuario',
                    'de'  => 'Benutzer',
                    "pt" => "Usuário",
                    "nl" => "Gebruiker",
                ],
                'widget' => [
                    'settings' => [],
                    'weight' => 0,
                    'type' => BridgeContentType::AUTOCOMPLETE_WIDGET,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => 'users',
                    'cardinality' => 1,
                ],
            ]);

            foreach ($movements as $movement) {
                $bridge->contentUpdate('movements', [
                    'uuid' => $movement->uuid,
                    'movements_users' => $movement->users->first()->uuid
                ]);
            }

            $bridgeType->contentTypeDeleteField('node', 'movements', 'users');
        }
    }
}
