<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema as InsideSchema;
use Inside\Content\Models\Contents\Custom;
use Inside\Host\Bridge\BridgeContent;

class CreateMovementsDefaultCustomPage extends Migration
{
    public function up(): void
    {
        $languages = list_languages();
        $data = [
            'fr' => [
                'title' => 'Mouvements',
                'introduction' => 'Retrouvez tous les mouvements',
            ],
            'en' => [
                'title' => 'Movements',
                'introduction' => 'Find all movements',
            ],
            'de' => [
                'title' => 'Bewegungen',
                'introduction' => 'Finde alle Bewegungen',
            ],
            'es' => [
                'title' => 'Movimientos',
                'introduction' => 'Encuentra todos los movimientos',
            ],
            "pt" => [
                "title" => "Movimentos",
                "introduction" => "Encontre todos os movimentos",
            ],
            "nl" => [
                "title" => "Bewegingen",
                "introduction" => "Bekijk alle bewegingen",
            ],
        ];

        if (! InsideSchema::hasModel('custom')) {
            return;
        }

        $bridge = new BridgeContent();

        $defaultLangcode = env('APP_LOCALE');

        $basePage = Custom::query()->where('langcode', $defaultLangcode)->where('title', $data[$defaultLangcode]['title'])->first();

        if (! $basePage) {
            $uuid = $bridge->contentInsert('custom', [
                'langcode' => $defaultLangcode,
                'title' => $data[$defaultLangcode]['title'],
                'introduction' => $data[$defaultLangcode]['introduction'],
                'custom_slug' => 'newcomers',
            ]);

            $basePage = Custom::find($uuid);
        }

        foreach ($languages as $langcode) {
            if ($langcode === $defaultLangcode) {
                continue;
            }

            $bridge->contentInsert('custom', [
                'langcode' => $langcode,
                'uuid_host' => $basePage->uuid_host,
                'title' => $data[$langcode]['title'],
                'introduction' => $data[$langcode]['introduction'],
                'custom_slug' => 'newcomers',
            ]);
        }
    }
}
